function [imgname]=ext_hdr2img(filename)
%[imgname]=ext_hdr2img(filename)
%convert the extension of a hdr file to '.img'.
%Input:
% filename: file name of a hdr file.
%Output:
% imgname: the same string as the input except that
%          the extension is '.img', not '.hdr'.
%
%20040318, jdlee
%
[path,name,ext] = fileparts(filename);
switch ext,
case '.hdr',
    imgname = fullfile(path,[name '.img']);
case '.img',
    imgname = filename;%do nothing
otherwise,
    error('The input is not a hdr or an img file name');
end

return
    